package gov.va.med.mhv.rxrefill.converter;

import gov.va.med.mhv.rxrefill.data.model.Institution;
import gov.va.med.mhv.rxrefill.dto.InstitutionDTO;

import org.springframework.stereotype.Component;

@Component
public class InstitutionConverter {

	public InstitutionDTO convertDomainInstitution(Institution institution) {
		InstitutionDTO institutionDto = new InstitutionDTO();
		
		institutionDto.setId(institution.getId());
		institutionDto.setOplock(institution.getOplock());
		institutionDto.setIsActive(institution.getIsActive());
		institutionDto.setIsTreatment(institution.getIsTreatment());
		institutionDto.setInstitutionId(institution.getInstitutionId());
		institutionDto.setStationNumber(institution.getStationNumber());
		institutionDto.setName(institution.getName());
		
		return institutionDto;
	}
	
	
	public Institution convertDTOInstitution(InstitutionDTO institutionDto) {
		Institution institution = new Institution();
		
		institution.setId(institutionDto.getId());
		institution.setOplock(institutionDto.getOplock());
		institution.setIsActive(institutionDto.getIsActive());
		institution.setIsTreatment(institutionDto.getIsTreatment());
		institution.setInstitutionId(institutionDto.getInstitutionId());
		institution.setStationNumber(institutionDto.getStationNumber());
		institution.setName(institutionDto.getName());
		
		return institution;
	}
}
